% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeExperiment.R
\name{summarizeExperiment}
\alias{summarizeExperiment}
\title{Summarize and collapse multiple mutational scanning experiments}
\usage{
summarizeExperiment(x, coldata, countType = "umis")
}
\arguments{
\item{x}{A named list of objects returned by \code{\link{digestFastqs}}.
Names are used to link the objects to the metadata provided in
\code{coldata}.}

\item{coldata}{A \code{data.frame} with at least one column "Name", which
will be used to link to objects in \code{x}. A potentially subset and
reordered version of \code{coldata} is stored in the \code{colData} of 
the returned \code{\link[SummarizedExperiment]{SummarizedExperiment}}.}

\item{countType}{Either "reads" or "umis". If "reads", the "count" assay of
the returned object will contain the observed number of reads for each
sequence (pair). If "umis", the "count" assay will contain the number of
unique UMIs observed for each sequence (pair).}
}
\value{
A \code{\link[SummarizedExperiment]{SummarizedExperiment}} \code{x}
    with
    \describe{
        \item{assays(x)$counts}{containing the observed number of sequences 
        or sequence pairs (if \code{countType} = "reads"), or the observed 
        number of unique UMIs for each sequence or sequence pair (if 
        \code{countType} = "umis").}
        \item{rowData(x)}{containing the unique sequences or sequence 
        pairs.}
        \item{colData(x)}{containing the metadata provided by 
        \code{coldata}.}
    }
}
\description{
Combine multiple sequence lists (as returned by \code{\link{digestFastqs}}
into a \code{\link[SummarizedExperiment]{SummarizedExperiment}}, with
observed variable sequences (sequence pairs) in rows and samples in columns.
}
\examples{
## Input sample
inp <- digestFastqs(
    fastqForward = system.file("extdata", "cisInput_1.fastq.gz", 
                               package = "mutscan"), 
    elementsForward = "SUCV", elementLengthsForward = c(1, 10, 18, 96), 
    constantForward = "AACCGGAGGAGGGAGCTG", 
    wildTypeForward = c(FOS = paste0(
        "ACTGATACACTCCAAGCGGAGACAGACCAACTAGAAGATGAGAAGTC", 
        "TGCTTTGCAGACCGAGATTGCCAACCTGCTGAAGGAGAAGGAAAAACTA")),
    nbrMutatedCodonsMaxForward = 1
)
## Output sample
outp <- digestFastqs(
    fastqForward = system.file("extdata", "cisOutput_1.fastq.gz", 
                               package = "mutscan"), 
    elementsForward = "SUCV", elementLengthsForward = c(1, 10, 18, 96), 
    constantForward = "AACCGGAGGAGGGAGCTG", 
    wildTypeForward = c(FOS = paste0(
        "ACTGATACACTCCAAGCGGAGACAGACCAACTAGAAGATGAGAAGTC", 
        "TGCTTTGCAGACCGAGATTGCCAACCTGCTGAAGGAGAAGGAAAAACTA")),
    nbrMutatedCodonsMaxForward = 1
)
## Combine
se <- summarizeExperiment(
    x = list(r1inp = inp, r1outp = outp), 
    coldata = data.frame(Name = c("r1inp", "r1outp"), 
                         Condition = c("input", "output"), 
                         Replicate = c("rep1", "rep1")),
    countType = "umis"
)
se

}
\author{
Michael Stadler, Charlotte Soneson
}
