% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTotals.R
\name{plotTotals}
\alias{plotTotals}
\title{Plot the column totals of a selected assay}
\usage{
plotTotals(se, selAssay = "counts", groupBy = NULL)
}
\arguments{
\item{se}{A \code{SummarizedExperiment} object, typically generated by 
\code{summarizeExperiment()}.}

\item{selAssay}{Character scalar specifying the assay in \code{se} to 
use for the plotting.}

\item{groupBy}{Character scalar indicating a column in 
\code{rowData(se)} to group the features by before calculating the 
column sums.}
}
\value{
A ggplot object.
}
\description{
Plot the column totals of a selected assay
}
\examples{
se <- readRDS(system.file("extdata", "GSE102901_cis_se.rds", 
                          package = "mutscan"))[1:200, ]
plotTotals(se)

}
\author{
Charlotte Soneson
}
