% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFiltering.R
\name{plotFiltering}
\alias{plotFiltering}
\title{Visualize the filtering procedure}
\usage{
plotFiltering(
  se,
  valueType = "reads",
  onlyActiveFilters = TRUE,
  displayNumbers = TRUE,
  numberSize = 4,
  plotType = "remaining",
  facetBy = "sample"
)
}
\arguments{
\item{se}{A \code{SummarizedExperiment} object, e.g. from 
\code{summarizeExperiment}.}

\item{valueType}{Either "reads" or "fractions", indicating whether to 
plot the number of reads, or the fraction of the total number of reads,
that are retained after/filtered out in each filtering step.}

\item{onlyActiveFilters}{Logical scalar, whether to only include the 
active filters (i.e., where any read was filtered out in any of the 
samples). Defaults to \code{TRUE}.}

\item{displayNumbers}{Logical scalar, indicating whether to display the 
number (or fraction) of reads retained at every filtering step.}

\item{numberSize}{Numeric scalar, indicating the size of the displayed 
numbers (if \code{displayNumbers} is \code{TRUE}).}

\item{plotType}{Character scalar, indicating what to show in the plot. 
Either \code{"remaining"} or \code{"filtered"}.}

\item{facetBy}{Character scalar, indicating the variable by which the plots 
should be facetted. Either \code{"sample"} or \code{"step"}.}
}
\value{
A \code{ggplot} object.
}
\description{
Display the number (or fraction) of reads remaining after each step 
of the internal \code{mutscan} filtering.
}
\details{
The function assumes that the number of reads filtered out in each step 
are provided as columns of \code{colData(se)}, with column names 
of the form \code{f[0-9]_filteringreason}, and that all filtering columns 
occur between the columns named \code{nbrTotal} and \code{nbrRetained}.
}
\examples{
se <- readRDS(system.file("extdata", "GSE102901_cis_se.rds", 
                          package = "mutscan"))[1:200, ]
plotFiltering(se)

}
\author{
Charlotte Soneson
}
