% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{calcNearestStringDist}
\alias{calcNearestStringDist}
\title{Calculate distances to the nearest string}
\usage{
calcNearestStringDist(x, metric = "hamming", nThreads = 1L)
}
\arguments{
\item{x}{A character vector.}

\item{metric}{A character scalar defining the string distance metric. One
of \code{"hamming"} (default), \code{"hamming_shift"} or
\code{"levenshtein"}.}

\item{nThreads}{numeric(1), number of threads to use for parallel processing.}
}
\value{
An integer vector of the same length as \code{x}.
}
\description{
Given a character vector, calculate the distance for each element
to the nearest neighbor amongst all the other elements.
}
\examples{
calcNearestStringDist(c("lazy", "hazy", "crazy"))
calcNearestStringDist(c("lazy", "hazy", "crazy"), metric = "hamming_shift")
calcNearestStringDist(c("lazy", "hazy", "crazy"), metric = "levenshtein")

}
