% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_heatmap.R
\name{plot_heatmap}
\alias{plot_heatmap}
\title{Plot heatmaps using the exposures matrix}
\usage{
plot_heatmap(
  musica,
  model_name,
  modality = "SBS96",
  result_name = "result",
  proportional = FALSE,
  show_column_names = FALSE,
  show_row_names = TRUE,
  scale = TRUE,
  subset_tumor = NULL,
  subset_signatures = NULL,
  annotation = NULL,
  ...
)
}
\arguments{
\item{musica}{A \code{\linkS4class{musica}} object containing a mutational
discovery or prediction.}

\item{model_name}{The name of the desired model.}

\item{modality}{The modality of the model. Must be "SBS96", "DBS78", or
"IND83". Default \code{"SBS96"}.}

\item{result_name}{Name of the result list entry containing desired model.
Default \code{"result"}.}

\item{proportional}{If \code{TRUE}, then the exposures will be normalized
to between 0 and 1 by dividing by the total number of counts for each sample.
Default \code{FALSE}.}

\item{show_column_names}{Boolean check. If \code{True}, column names are
shown. Otherwise, they aren't.
Default \code{FALSE}}

\item{show_row_names}{Boolean check. If \code{True}, row names are shown.
Otherwise, they aren't.
Default \code{FALSE}}

\item{scale}{Boolean check. If \code{True}, values are scaled by z-score.
Otherwise, they aren't.
Default \code{TRUE}}

\item{subset_tumor}{Users can specify certain tumor types on which
they want to subset the exposure matrix for
plotting the heatmap.}

\item{subset_signatures}{Users can specify certain signatures on
 which they want to subset the exposure matrix
plotting the heatmap.}

\item{annotation}{Users have the option of plotting the exposure matrix
based on their given annotation like
Tumor_Subtypes or age. Error given if the user given annotation
doesn't exist in the res_annot annotation object.}

\item{...}{Ellipsis used for passing any arguments directly
to the ComplexHeatmap's heatmap function.}
}
\value{
Generates a heatmap for using the exposure matrix.
}
\description{
The exposures for different signatures can be
visualized using a heatmap with this function.
Heatmaps make it easier to visualize the data by
representing the magnitude of exposure values
as color in 2-dimensions. The variation in color
intensity can help see if the exposures are clustered
or how they vary over space. Exposures can be
normalized by providing the \code{proportional} argument.
Column annotations can also be seen by passing the \code{col_annot} argument.
}
\examples{
data(res_annot)
plot_heatmap(
  musica = res_annot, model_name = "res_annot",
  proportional = TRUE, scale = TRUE, annotation = "Tumor_Subtypes"
)
}
