% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_result_model.R
\name{other_parameters}
\alias{other_parameters}
\alias{other_parameters,musica-method}
\alias{other_parameters,result_collection-method}
\alias{other_parameters,result_model-method}
\alias{other_parameters<-}
\alias{other_parameters<-,musica,matrix-method}
\alias{other_parameters<-,result_collection,matrix-method}
\alias{other_parameters<-,result_model,matrix-method}
\title{Retrieve other_parameters from a result_model, result_collection, or
musica object}
\usage{
other_parameters(x, ...)

\S4method{other_parameters}{musica}(x, result, modality, model_id)

\S4method{other_parameters}{result_collection}(x, modality, model_id)

\S4method{other_parameters}{result_model}(x)

other_parameters(x, ...) <- value

\S4method{other_parameters}{musica,matrix}(x, result, modality, model_id) <- value

\S4method{other_parameters}{result_collection,matrix}(x, modality, model_id) <- value

\S4method{other_parameters}{result_model,matrix}(x) <- value
}
\arguments{
\item{x}{A \code{\linkS4class{musica}},
\code{\linkS4class{result_collection}}, or \code{\linkS4class{result_model}}
object generated by a mutational discovery or prediction tool.}

\item{...}{Other inputs}

\item{result}{Name of result from result_list to assign the other_parameters.
Used when \code{result} is a \code{\linkS4class{musica}} object.}

\item{modality}{Modality to assign the other_parameters. Used when
\code{result} is a \code{\linkS4class{musica}} or
\code{\linkS4class{result_collection}} object.}

\item{model_id}{Model identifier to assign the other_parameters. Used when
\code{result} is a \code{\linkS4class{musica}} or
\code{\linkS4class{result_collection}} object.}

\item{value}{List of other parameters}
}
\value{
The other parameters for the model
}
\description{
Parameters for the model
}
\examples{
data(res)
other_parameters(res, "result", "SBS96", "res")
}
