% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_result_collection.R
\name{get_model}
\alias{get_model}
\alias{get_model,musica-method}
\alias{get_model,result_collection-method}
\title{Retrieve model from a musica or result collection object}
\usage{
get_model(x, ...)

\S4method{get_model}{musica}(x, result, modality, model)

\S4method{get_model}{result_collection}(x, modality, model)
}
\arguments{
\item{x}{A \code{\linkS4class{musica}} or
\code{\linkS4class{result_collection}} object.}

\item{...}{Other inputs}

\item{result}{The name of the result_list entry.}

\item{modality}{The modality.}

\item{model}{The name of the model.}
}
\value{
A \code{\linkS4class{result_model}} object
}
\description{
Extract the \code{\linkS4class{result_model}} object from the
\code{\linkS4class{musica}} or \code{\linkS4class{result_collection}} object
that contains the model.
}
\examples{
data(res)
get_model(res, "result", "SBS96", "res")
}
