% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_utils.R
\name{build_custom_table}
\alias{build_custom_table}
\title{Builds a custom table from specified user variants}
\usage{
build_custom_table(
  musica,
  variant_annotation,
  name,
  description = character(),
  data_factor = NA,
  annotation_df = NULL,
  features = NULL,
  type = NULL,
  color_variable = NULL,
  color_mapping = NULL,
  return_instead = FALSE,
  overwrite = FALSE
)
}
\arguments{
\item{musica}{A \code{\linkS4class{musica}} object.}

\item{variant_annotation}{User column to use for building table}

\item{name}{Table name to refer to (must be unique)}

\item{description}{Optional description of the table content}

\item{data_factor}{Full set of table values, in case some are missing from
the data. If NA, a superset of all available unique data values will be used}

\item{annotation_df}{A data.frame of annotations to use for plotting}

\item{features}{A data.frame of the input data from which the count table
will be built}

\item{type}{The type of data/mutation in each feature as an Rle object}

\item{color_variable}{The name of the column of annotation_df used for the
coloring in plots}

\item{color_mapping}{The mapping from the values in the selected
color_variable column to color values for plotting}

\item{return_instead}{Instead of adding to musica object, return the created
table}

\item{overwrite}{Overwrite existing count table}
}
\value{
If return_instead = TRUE then the created table object is returned,
otherwise the table object is automatically added to the musica's
count_tables list and nothing is returned
}
\description{
Builds a custom table from specified user variants
}
\examples{
data(musica)
annotate_transcript_strand(musica, "19", build_table = FALSE)
build_custom_table(musica, "Transcript_Strand", "Transcript_Strand",
  data_factor = factor(c("T", "U"))
)
}
