% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate_variants.R
\name{add_flank_to_variants}
\alias{add_flank_to_variants}
\title{Uses a genome object to find context and add it to the variant table}
\usage{
add_flank_to_variants(
  musica,
  g,
  flank_start,
  flank_end,
  build_table = TRUE,
  overwrite = FALSE
)
}
\arguments{
\item{musica}{Input samples}

\item{g}{A \linkS4class{BSgenome} object indicating which genome
reference the variants and their coordinates were derived from.}

\item{flank_start}{Start of flank area to add, can be positive or negative}

\item{flank_end}{End of flank area to add, can be positive or negative}

\item{build_table}{Automatically build a table using the annotation and add}

\item{overwrite}{Overwrite existing count table}
}
\value{
None
it to the musica
}
\description{
Uses a genome object to find context and add it to the variant table
}
\examples{
data(musica_sbs96_tiny)
g <- select_genome("19")
add_flank_to_variants(musica_sbs96_tiny, g, 1, 2)
add_flank_to_variants(musica_sbs96_tiny, g, -2, -1)
}
