% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06_find_primespacers.R
\name{find_gg}
\alias{find_gg}
\title{Find GG}
\usage{
find_gg(gr)
}
\arguments{
\item{gr}{\code{\link[GenomicRanges]{GRanges-class}}}
}
\value{
\code{\link[GenomicRanges]{GRanges-class}}
}
\description{
Find GG
}
\examples{
# PE example
#-----------
    require(magrittr)
    bsgenome <- BSgenome.Hsapiens.UCSC.hg38::BSgenome.Hsapiens.UCSC.hg38  
    gr <- char_to_granges(c(PRNP = 'chr20:4699600:+',            # snp
                            HBB  = 'chr11:5227002:-',             # snp
                            HEXA = 'chr15:72346580-72346583:-',   # del
                            CFTR = 'chr7:117559593-117559595:+'), # ins
                          bsgenome)
    gr \%<>\% extend_pe_to_gg(plot = TRUE) \%>\% add_seq(bsgenome) 
    find_gg(gr)
}
