% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_bed_to_granges.R
\name{char_to_granges}
\alias{char_to_granges}
\title{Convert character vector into GRanges}
\usage{
char_to_granges(x, bsgenome)
}
\arguments{
\item{x}{character vector}

\item{bsgenome}{\code{\link[BSgenome]{BSgenome-class}}}
}
\value{
\code{\link[GenomicRanges]{GRanges-class}}
}
\description{
Convert character vector into GRanges
}
\examples{
require(magrittr)
bsgenome <- BSgenome.Hsapiens.UCSC.hg38::BSgenome.Hsapiens.UCSC.hg38  
x <- c(PRNP  = 'chr20:4699600:+',            # snp
       HBB  = 'chr11:5227002:-',            # snp
       HEXA = 'chr15:72346580-72346583:-',  # del
       CFTR = 'chr7:117559593-117559595:+') # ins
gr <- char_to_granges(x, bsgenome)
plot_intervals(gr, facet_var = c('targetname', 'seqnames'))
}
\seealso{
\code{\link{bed_to_granges}}, \code{\link{genes_to_granges}}
}
