% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preservation.R
\name{diffCoexpression}
\alias{diffCoexpression}
\title{Differential co-expresison analysis}
\usage{
diffCoexpression(
  datExpr,
  conditions,
  geneList = NULL,
  plot = FALSE,
  method = c("pearson", "spearman"),
  removeFreeNodes = TRUE,
  labelSize = 0.5,
  labelDist = 0,
  shape = "circle",
  degreeForSize = FALSE,
  label = FALSE,
  onlyPositive = FALSE,
  z.threshold = NULL,
  FDR.threshold = 0.05,
  nodeSize = 3
)
}
\arguments{
\item{datExpr}{a data.frame containing expression values}

\item{conditions}{a vector containing conditions for the samples}

\item{geneList}{vector of genes, will use all genes if NULL (default)}

\item{plot}{plot a network?}

\item{method}{either "pearson" or "spearman"}

\item{removeFreeNodes}{remove free nodes from network?}

\item{labelSize}{label size}

\item{labelDist}{distance from labels to nodes}

\item{shape}{shape of nodes}

\item{degreeForSize}{should node size correspond to degree?}

\item{label}{label nodes?}

\item{onlyPositive}{only draw positive correlations?}

\item{z.threshold}{z-score threshold}

\item{FDR.threshold}{FDR threshold}

\item{nodeSize}{size of node}
}
\value{
A list including a matrix of z-scores, a matrix of raw p-values, a 
matrix of adjusted p-values, and a summary data.frame
}
\description{
Performs a differential co-expression ananlysis given an expression data.frame 
and a conditions vector
}
\examples{
library(ExperimentHub)
eh = ExperimentHub()
eh_query = query(eh, c("multiWGCNAdata"))
astrocyte_se = eh_query[["EH8223"]]
datExpr = assays(astrocyte_se)[[1]]
diffCoexpression(datExpr, c(rep(1,20), rep(2,16)), 
  geneList = c("Gfap", "Vim", "Aspg", "Serpina3n", "Cp", "Osmr", "Cd44", 
    "Cxcl10", "Hspb1", "Timp1", "S1pr3", "Steap4", "Lcn2"))

}
\author{
Dario Tommasini
}
