% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preservation.R
\name{PreservationScoreDistribution}
\alias{PreservationScoreDistribution}
\title{PreservationScoreDistribution}
\usage{
PreservationScoreDistribution(preservationData, moduleOfInterestSize)
}
\arguments{
\item{preservationData}{the results from PreservationPermutationTest}

\item{moduleOfInterestSize}{the number of genes in your module of interest}
}
\value{
A data.frame with Z-summary preservation scores of the module from
each permutation and the corresponding module size
}
\description{
Extracts the preservation score distribution from the results of 
PreservationPermutationTest.
}
\examples{
# Remove outlier modules
permutationTestResultsFiltered = lapply(permutationTestResults, function(x) x[!x$is.outlier.module,])

# Find preservation score distribution for a given module size
scores.summary = PreservationScoreDistribution(permutationTestResultsFiltered, 
                                               moduleOfInterestSize = 303)
                                                        
}
\author{
Dario Tommasini
}
