% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{MD_composite}
\alias{MD_composite}
\title{Plot a composite MD plot with the results of a comparison}
\usage{
MD_composite(hicexp, plot.chr = NA, D.range = 1)
}
\arguments{
\item{hicexp}{A hicexp object which has 
had a multiHiCcompare comparison step performed on it.}

\item{plot.chr}{A specific chromosome or 
set of chromosome which you want to plot.
This should be a numeric value, i.e. to
plot chromosome 1 set plot.chr = 1, to
plot chromosomes 1 and 5 set plot.chr 
= c(1, 5). Defaults to NA indicating that
all chromosomes present in the hicexp
will be plotted.}

\item{D.range}{Allows for subsetting of the plot by
Distance. Set to proportion of total distance 
that you want to be displayed. Value of 1 
indicates that the entire distance range 
will be displayed. Defaults to 1.}
}
\value{
An MD plot
}
\description{
Plot a composite MD plot with the results of a comparison
}
\examples{
data("hicexp_diff")
MD_composite(hicexp_diff)
}
