% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_processing.R
\name{getMultiOmicsFeatures}
\alias{getMultiOmicsFeatures}
\title{Collect feature mapping for user given databases and omics layer.}
\usage{
getMultiOmicsFeatures(
  dbs = c("all"),
  layer = c("all"),
  returnTranscriptome = "SYMBOL",
  returnProteome = "SYMBOL",
  returnMetabolome = "HMDB",
  organism = "hsapiens",
  useLocal = TRUE
)
}
\arguments{
\item{dbs}{List of databases that should be queried for pathways. Default:
all available databases}

\item{layer}{List of omics layer that should be addressed. Default: all three
layer (transcriptome, proteome, metabolome)}

\item{returnTranscriptome}{String specifying the returned gene ID format.
Default: SYMBOL Options: SYMBOL, ENTREZID, UNIPROT, ENSEMBL, REFSEQ}

\item{returnProteome}{String specifying the returned protein ID format.
Default: SYMBOL Options: SYMBOL, ENTREZID, UNIPROT, ENSEMBL, REFSEQ}

\item{returnMetabolome}{String specifying the returned metabolite ID format.
Default: HMDB Options: HMDB, CAS, DTXCID, DTXSID, SID, CID, ChEBI, KEGG, Drugbank}

\item{organism}{String specifying the organism of interest. This has direct
influence on the available pathway databases. Default: "hsapiens"
Options: see \code{\link[multiGSEA]{getOrganisms}}}

\item{useLocal}{Boolean to use local pathway/feature descriptions. In case
useLocal is set to FALSE, pathway definitions and feature extraction
will be recalculated. This could take several minutes depending on the
database used. Pathbank, for example, contains nearly 50000 pathway
definition that have to be re-mapped. useLocal has no effect when
pathway definitions are retrieved for the first time. Default: TRUE}
}
\value{
Nested list with extracted and mapped pathway features.
}
\description{
The functions makes use of the graphite R package to collect pathways from
user specified databases. Depending on the omics layer specified, the
function extracts either annotated genes/proteins (for transcriptome,
proteome layer) or metabolites (for metabolite layer). The data structure
that is returned is mandatory to calculate the multi-omics pathway
enrichment.
}
\examples{

getMultiOmicsFeatures(
  dbs = c("kegg"),
  layer = c("transcriptome", "proteome"),
  organism = "hsapiens"
)
\donttest{
getMultiOmicsFeatures(
  dbs = c("kegg", "reactome"),
  layer = c("transcriptome", "metabolome"),
  organism = "mmusculus"
)

getMultiOmicsFeatures(
  dbs = c("reactome"),
  layer = c("proteome"),
  organism = "rnorvegicus",
  returnProteome = "ENTREZID"
)
}
}
