% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findVariableFeatures.R
\name{findVariableFeatures}
\alias{findVariableFeatures}
\title{Find highly variable peptides}
\usage{
findVariableFeatures(y)
}
\arguments{
\item{y}{numeric matrix giving log-intensity. Can contain NA values. Peptides with insufficient observations will be ignored.}
}
\value{
A data frame where rows are peptides and columns contain estimates of biological and technical variances. Peptides are ordered by biological variance.
}
\description{
For each peptide, the total variance is decomposed into biological and technical variance using package \code{scran}
}
\details{
A loess trend is fitted to total sample variances and mean intensities. For each peptide, the biological variance is then
computed by subtracting the estimated technical variance from the loess fit from the total sample variance.
}
\examples{
data(pxd007959)
findVariableFeatures(data.matrix(log2(pxd007959$y)))

}
\seealso{
computeStructuralMetrics
}
