% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_wrapper.R
\name{numMotifHits}
\alias{numMotifHits}
\title{Number of motif hits in a set of DNA sequences}
\usage{
numMotifHits(seqs, pfm, bg, singlestranded = FALSE)
}
\arguments{
\item{seqs}{A DNAStringSet or DNAString object}

\item{pfm}{An R matrix that represents a position frequency matrix}

\item{bg}{A Background object}

\item{singlestranded}{Boolean that indicates whether a single strand or
both strands shall be scanned for motif hits.
Default: singlestranded = FALSE.}
}
\value{
A list containing
\describe{
\item{nseq}{Number of individual sequences}
\item{lseq}{Vector of individual sequence lengths}
\item{numofhits}{Vector of the number of hits in each individual sequence}
}
}
\description{
This function counts the number of motif hits that
are found in a given set of DNA sequences.
}
\details{
Optionally, it can be used to count motif hits on
one or both strands, respectively.
}
\examples{

# Load sequences
seqfile = system.file("extdata", "seq.fasta", package = "motifcounter")
seqs = Biostrings::readDNAStringSet(seqfile)

# Load background
bg = readBackground(seqs, 1)

# Load motif
motiffile = system.file("extdata", "x31.tab", package = "motifcounter")
motif = t(as.matrix(read.table(motiffile)))

# Count motif hits both strands
noc = motifcounter:::numMotifHits(seqs, motif, bg)
noc$numofhits

# Count motif hits on a single strand
noc = motifcounter:::numMotifHits(seqs, motif, bg, singlestranded = TRUE)
noc$numofhits

}
