% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_wrapper.R
\name{motifHits}
\alias{motifHits}
\title{Motif hit observations}
\usage{
motifHits(seq, pfm, bg, threshold = NULL)
}
\arguments{
\item{seq}{A DNAString object}

\item{pfm}{An R matrix that represents a position frequency matrix}

\item{bg}{A Background object}

\item{threshold}{Score threshold for calling motif matches. If NULL,
the threshold will determined from alpha.}
}
\value{
List containing
\describe{
\item{fhits}{Per-position motif hits on the forward strand}
\item{rhits}{Per-position motif hits on the reverse strand}
}
}
\description{
This function determines per-position motif hits in a given DNA sequence.
}
\examples{


# Load sequences
seqfile = system.file("extdata", "seq.fasta", package = "motifcounter")
seq = Biostrings::readDNAStringSet(seqfile)

# Load background
bg = readBackground(seq, 1)

# Load motif
motiffile = system.file("extdata", "x31.tab", package = "motifcounter")
motif = t(as.matrix(read.table(motiffile)))

# Determine the motif hits
motifHits(seq[[1]], motif, bg)

}
