% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psam.R
\docType{class}
\name{psam-class}
\alias{psam-class}
\alias{psam}
\alias{$,psam-method}
\alias{$<-,psam-method}
\alias{plot,psam,ANY-method}
\alias{as()}
\alias{coerce,psam,matrix-method}
\alias{matrixReverseComplement,psam-method}
\alias{addBlank,psam,numeric,logical-method}
\alias{as.data.frame,psam-method}
\alias{format,psam-method}
\title{Class \code{"psam"}}
\usage{
\S4method{$}{psam}(x, name)

\S4method{plot}{psam,ANY}(x, y = "missing", ...)

\S4method{matrixReverseComplement}{psam}(x)

\S4method{addBlank}{psam,numeric,logical}(x, n, b)

\S4method{as.data.frame}{psam}(x, row.names = NULL, optional = FALSE, ...)

\S4method{format}{psam}(x, ...)
}
\arguments{
\item{x}{An object of class \code{psam}.}

\item{name}{Slot name.}

\item{y}{Not use.}

\item{\dots}{Further potential arguments passed to \code{plotAffinityLogo}.}

\item{n}{how many spaces should be added.}

\item{b}{logical value to indicate where the space should be added.}

\item{row.names, optional}{see as.data.frame}
}
\description{
An object of class \code{"psam"} represents the position specific affinity
matrix (PSAM) of a DNA/RNA/amino-acid sequence motif. The entry stores a
matrix, which in row i, column j gives the affinity of observing
nucleotide/or amino acid i in position j of the motif.

methods for psam objects.
}
\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new("psam", mat, name, alphabet, color)}.
}

\section{Methods}{
 \describe{ \item{addBlank}{\code{signature(x="psam",
n="numeric", b="logical")} add space into the position specific affinity
matrix for alignment. b is a bool value, if TRUE, add space to the 3' end,
else add space to the 5' end. n indicates how many spaces should be added.}

\item{matrixReverseComplement}{\code{signature(x = "psam")} get the reverse
complement of position specific affinity matrix.}

\item{plot}{\code{signature(x = "psam")} Plots the affinity logo of the
position specific affinity matrix. }

\item{$, $<-}{Get or set the slot of \code{\link{psam-class}}}
\item{as.data.frame}{convert \code{\link{psam-class}} to a data.frame}
\item{format}{return the name_pfm of \code{\link{psam-class}}} }
}

\examples{

motif <- importMatrix(file.path(find.package("motifStack"), "extdata", "PSAM.mxr"), 
         format="psam")[[1]]
plot(motif)


motif <- importMatrix(file.path(find.package("motifStack"), "extdata", "PSAM.mxr"), 
                      format="psam")[[1]]
matrixReverseComplement(motif)
addBlank(motif, 1, FALSE)
addBlank(motif, 3, TRUE)
as(motif,"matrix")
as.data.frame(motif)
format(motif)

}
\keyword{classes}
