% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bicluster_net_methods.R
\name{plot_piechart_bicluster_network}
\alias{plot_piechart_bicluster_network}
\title{Plot a bicluster network with piecharts as nodes.}
\usage{
plot_piechart_bicluster_network(
  bic_net,
  bics,
  class_vector,
  colors,
  named = TRUE,
  MARGIN = "column",
  new_layout = TRUE,
  ...
)
}
\arguments{
\item{bic_net}{A \code{\link{bicluster_net}} object.}

\item{bics}{The corresponding list of biclusters from \code{bic_net}.
After calculating communities with \code{\link{get_louvain_communities}}
it is necessary to get the subset of biclusters
using \code{\link{select_biclusters_from_bicluster_network}}.}

\item{class_vector}{A (named) vector with class affinities. Every occuring
element in the biclustes must have a non NA value in this list.}

\item{colors}{Colors used for the classes. Must be a vector with colors in
the order of sort(unique(class_vector)).}

\item{named}{Indicates if \code{rowname}/\code{colname} of the bicluster
objects should be used instead of the indizes.}

\item{MARGIN}{Must be "row" or "column". Indicates which dimension of the
bicluster should be used for coloring.}

\item{new_layout}{If \code{FALSE}, the plot accepts a network layout as a
parameter, other wise a new layout is computed.}

\item{...}{Additional parameters forwarded
to \code{\link[igraph]{plot.igraph}}.}
}
\value{
If \code{new_layout}, a new network layout is returned that can
be used for other plots.
}
\description{
Plot a bicluster network with piecharts as nodes.
}
\examples{
m <- matrix(seq(1:16), nrow=4)
# m <- matrix(rnorm(10000), nrow=100)
# bics <- c(run_fabia(m), run_isa(m), run_plaid(m))
# bn <- bicluster_network(bics, m)
# groups <- ifelse(runif(100)< 0.5, "group1", "group2")
# cols <- c("group1"="blue", "group2"="grey")
# plot_piechart_bicluster_network(bn, bics, groups, cols, named=FALSE)

}
