% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bicluster_net_methods.R
\name{plot_algo_network}
\alias{plot_algo_network}
\title{Plot a bicluster network colored by algorithms.}
\usage{
plot_algo_network(bic_net, bics, new_layout = TRUE, ...)
}
\arguments{
\item{bic_net}{A \code{\link{bicluster_net}} object.}

\item{bics}{The corresponding list of biclusters from \code{bic_net}.}

\item{new_layout}{If \code{FALSE}, the plot accepts a network layout as
a parameter, other wise a new layout is computed.}

\item{...}{Plot parameters forwarded
to \code{igraph::\link[igraph]{plot.igraph}}
After calculating communities with \code{\link{get_louvain_communities}}
it is necessary to get the subset of biclusters
using \code{\link{select_biclusters_from_bicluster_network}}.}
}
\value{
If \code{new_layout}, a new network layout is returned
that can be used for other plots.
}
\description{
In the plot each bicluster is colored by the algorithm, that generated it.
}
\examples{
m <- matrix(seq(1:16), nrow=4)
# m <- matrix(rnorm(10000), nrow=100)
# bics <- c(run_fabia(m), run_isa(m), run_plaid(m))
# bn <- bicluster_network(bics, m)
# plot_algo_network(bn, bics)

}
