% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_akmbiclust.R
\name{getAkmbiclustClusters}
\alias{getAkmbiclustClusters}
\title{Extract a list of bicluster objects from an akmbiclust biclustering object.}
\usage{
getAkmbiclustClusters(bics, mat, transposed = FALSE, filterfun = NULL, ...)
}
\arguments{
\item{bics}{A result object from akmbiclust.}

\item{mat}{Original matrix, that was used for biclustering.}

\item{transposed}{\code{True}, if the bicluster calculation was
performed on a tranposed matrix.}

\item{filterfun}{A function to filter biclusters.
Only if the function returns \code{True}, the bicluster is added to the
returned list. The function has to accept a the
bicluster (given as submatrix
of \code{mat}) \code{filterfun(bicluster_matrix, ...)}.}

\item{...}{Other parameters forwarded to the \code{filterfun}.}
}
\value{
A list of \code{\link{bicluster}} objects, which have to be
valid (See \code{\link{validate_bicluster}}.
}
\description{
Extract a list of bicluster objects from an akmbiclust biclustering object.
}
\examples{
# Function called in
m <- matrix(seq(1:16), nrow=4)
# m <- matrix(rnorm(10000), nrow=100)
# Not run: run_akmbiclust(m, k=10)

}
