% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_biclusters.R
\name{filter_biclusters}
\alias{filter_biclusters}
\title{Filter biclusters based on a user defined filter function.}
\usage{
filter_biclusters(bics, mat, filterfun, ...)
}
\arguments{
\item{bics}{A list of valid bicluster objects.}

\item{mat}{Original matrix, that was used for biclustering.}

\item{filterfun}{A function to filter biclusters. Only if the function
returns \code{True}, the bicluster is added to the returned list.
The function has to accept a the bicluster (given as submatrix
of \code{mat}) \code{filterfun(bicluster_matrix, ...)}.}

\item{...}{Other parameters forwarded to the \code{filterfun}.}
}
\value{
A filtered list ob bicluster objects with
length(returned_list)<=length(bics).
}
\description{
If the function returns \code{True}, the bicluster is added to the output
list of biclusters.
Every bicluster is validated, before forwarding to the filter-function.
}
\examples{
# m <- matrix(runif(100), nrow=10)
b <- list(bicluster(row=c(3,4), column=c(3,4)),
    bicluster(row=c(3,4,5,6), column=c(3,4,5,6)),
    bicluster(row=c(3,4,5,6), column=c(3,6)))
# filter_biclusters(b, m, function(x) sum(x) < 0)

}
