% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline.R
\name{feature_network}
\alias{feature_network}
\title{Generate a co-occurence network}
\usage{
feature_network(
  bics,
  mat,
  n_randomizations = 5,
  n_steps = 100,
  plot_edge_dist = TRUE,
  sn_ratio = 1,
  error_threshold = 0.05,
  return_plot_data = FALSE,
  rr = 1,
  rc = 1,
  cc = 1,
  w = 0
)
}
\arguments{
\item{bics}{A list of bicluster objects.}

\item{mat}{The matrix used for biclustering.}

\item{n_randomizations}{The number of randomizations for cut-off
estimation. (The mean of all randomizations is used).}

\item{n_steps}{Number of points where the difference between
randomizations and the real data is evaluated.}

\item{plot_edge_dist}{Show the plots for threshold estimation.}

\item{sn_ratio}{If \code{TRUE}, the signal to noise ratio is
computed, otherwise the \code{error_threshold} is used to to
estimate the threshold at which only \code{error_threshold*100} percent
of the edges are estimated to be random overlaps.}

\item{error_threshold}{If \code{sn_ratio==FALSE} this cut-off is
used to estimate the cut-off at which only \code{error_threshold*100}
percent of the edges are estimated to be random overlaps.}

\item{return_plot_data}{Please do not use outside of the package.}

\item{rr}{See \code{\link{full_graph}}.}

\item{rc}{See \code{\link{full_graph}}.}

\item{cc}{See \code{\link{full_graph}}.}

\item{w}{See parameter weighting of \code{\link{full_graph}}.}
}
\value{
An object of class \code{\link{cooccurrence_net}}.
}
\description{
The function computes a co-occurence network, based on the
function \code{\link{full_graph}}.
A similarity threshold is calculated using randomized
biclusters (the bicluster size distribution is kept).
}
\examples{
m <- matrix(seq(1:16), nrow=4)
# m <- matrix(rnorm(10000), nrow=100)
# bics <- c(run_fabia(m), run_isa(m), run_plaid(m))
# feature_network(bics, m)

}
