% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline.R
\name{bicluster_network}
\alias{bicluster_network}
\title{Generate a bicluster network}
\usage{
bicluster_network(
  bics,
  mat,
  n_randomizations = 5,
  MARGIN = "both",
  metric = 4,
  n_steps = 100,
  plot_edge_dist = TRUE,
  sn_ratio = TRUE,
  error_threshold = 0.05,
  return_plot_data = FALSE,
  prob_scale = FALSE,
  prl = FALSE
)
}
\arguments{
\item{bics}{A list of bicluster objects.}

\item{mat}{The matrix used for biclustering.}

\item{n_randomizations}{The number of randomizations for
cut-off estimation. (The mean of all randomizations is used).}

\item{MARGIN}{Margin over which the similarity is computed.
Can be "row", "column", "mean" (In this case the mean of
row and column similarity is used) or "both" (In this case
the similarity between all the datapoints of biclusters is used).}

\item{metric}{The similarity metric same as
in \code{\link{similarity_matrix}}.}

\item{n_steps}{Number of points where the difference
between randomizations and the real data is evaluated.}

\item{plot_edge_dist}{Show the plots for cut-off estimation
with the error model.}

\item{sn_ratio}{If \code{TRUE}, the signal to noise ratio is
computed, otherwise the \code{error_threshold} is used to to
estimate the cut-off at which only \code{error_threshold*100}
percent of the edges are estimated to be random overlaps.}

\item{error_threshold}{If \code{sn_ratio==FALSE} this threshold
is used to estimate the threshold at which
only \code{error_threshold*100} percent of the edges are
estimated to be random overlaps.}

\item{return_plot_data}{Please do not use outside of the package.}

\item{prob_scale}{Scale similarity by the probability of an
overlap equal of higher to the observed one. The scaling is
done by multiplying the similarity
with \code{(1 - (1 / (1 - log(overlap_probability, base=100))))}.
The probability is computed using the f
unction \code{\link{p_overlap_2d_higher}}
for \code{MARGIN =="both"} and  \code{\link{p_overlap_higher}}
otherwise. Can be helpful for big imbalances of bicluster sizes.}

\item{prl}{Compute the similarity matrix using multiple
cores (works only for \code{MARGIN="both"}). The number of core can be
defined by executing: \code{RcppParallel::setThreadOptions(numThreads = 4)}
before running this function.}
}
\value{
An object of class \code{\link{bicluster_net}}.
}
\description{
The function computes a bicluster network based on a selected
similarity metric.
A similarity cut-off is calculated using randomized
biclusters (the bicluster size distribution is kept).
}
\examples{
m <- matrix(seq(1:16), nrow=4)
# m <- matrix(rnorm(10000), nrow=100)
# bics <- c(run_fabia(m), run_isa(m), run_plaid(m))
# bicluster_network(bics, m)

}
