% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bicluster.R
\docType{class}
\name{bicluster_net-class}
\alias{bicluster_net-class}
\alias{bicluster_net}
\title{A S4 class to store bicluster networks.}
\description{
Object that is returned e.g. be the
function \code{\link{bicluster_network}}.
}
\section{Slots}{

\describe{
\item{\code{adjacency_matrix}}{Adjacency matrix of bicluster similarities.}

\item{\code{threshold}}{Estimated threshold for the bicluster similarity adjacency
matrix. All values lower than that in the matrix should be discarded.
(Note that the indicated threshold is not applied
to the \code{adjacency_matrix})}

\item{\code{algorithms}}{List of algorithms that contributed to this bicluster
network.}
}}

\examples{
bicluster_net(adjacency_matrix=matrix(seq(1:16), nrow=4),
    threshold=4)
}
