% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{splines_kmeans}
\alias{splines_kmeans}
\alias{splines_kmeans,Moanin-method}
\title{Performs splines clustering using K-means}
\usage{
\S4method{splines_kmeans}{Moanin}(
  object,
  n_clusters = 10,
  init = "kmeans++",
  n_init = 10,
  max_iter = 300,
  random_seed = .Random.seed[1],
  fit_splines = TRUE,
  rescale = TRUE
)
}
\arguments{
\item{object}{An object of class \code{\link{Moanin}}, an object containing
all related information for time course data and the splines model that
will be used (if applicable). See \code{\link{create_moanin_model}} for
more details.}

\item{n_clusters}{int optional, default: 10}

\item{init}{["kmeans++", "random", "optimal_init"]}

\item{n_init}{int, optional, default: 10
Number of initialization to perform.}

\item{max_iter}{int, optional, default: 300
Maximum number of iteration to perform}

\item{random_seed}{int, optional, default: NULL. 
Passed to argument \code{seed} in  \code{\link[ClusterR]{KMeans_rcpp}}. 
If NULL (default), set to \code{.Random.seed[1]}.}

\item{fit_splines}{boolean, optional, default: TRUE
Whether to fit splines or not.}

\item{rescale}{boolean, optional, default: TRUE
Whether to rescale the data or not.}
}
\value{
A list in the format returned by \code{\link[ClusterR]{KMeans_rcpp}},
   with the following elements added or changed:
\itemize{
\item{\code{centroids}}{ The centroids are rescaled so that they range from
0-1}
\item{\code{fit_splines}}{ Logical, the value of \code{fit_splines} given to the
function }
\item{\code{rescale}}{ The value of \code{rescale} given to the function }
}
}
\description{
Performs splines clustering using K-means
}
\details{
If \code{\link{Moanin}} object's slot has log_transform=TRUE, then the data will be transformed by the function log(x+1) before applying splines and clustering.
}
\examples{
data(exampleData)
# Use the default options
moanin <- create_moanin_model(data=testData, meta=testMeta)
out <- splines_kmeans( moanin,n_clusters=5)
table(out$clusters)
}
