% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnems.r
\name{plotConvergence.mnem}
\alias{plotConvergence.mnem}
\title{Plot convergence of EM}
\usage{
\method{plotConvergence}{mnem}(x, col = NULL, type = "b", convergence = 0.1, ...)
}
\arguments{
\item{x}{mnem object}

\item{col}{vector of colors for the iterations}

\item{type}{see ?plot.default}

\item{convergence}{difference of when two log likelihoods
are considered equal; see also convergence for the function
mnem()}

\item{...}{additional parameters for the plots/lines functions}
}
\value{
plot of EM convergence
}
\description{
This function plots the convergence of the different EM iterations (four
figures, e.g. par(mfrow=(2,2))).
}
\examples{
sim <- simData(Sgenes = 3, Egenes = 2, Nems = 2, mw = c(0.4,0.6))
data <- (sim$data - 0.5)/0.5
data <- data + rnorm(length(data), 0, 1)
result <- mnem(data, k = 2, starts = 1)
par(mfrow=c(2,2))
plotConvergence(result)
}
\author{
Martin Pirkl
}
