% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnems.r
\name{fuzzyindex}
\alias{fuzzyindex}
\title{Calculate fuzzy ground truth.}
\usage{
fuzzyindex(x, data, logtype = 2, complete = FALSE, marginal = FALSE, ...)
}
\arguments{
\item{x}{mnem_sim object}

\item{data}{noisy data matrix}

\item{logtype}{logarithm type of the data}

\item{complete}{if TRUE, complete data log likelihood is considered (for
very large data sets, e.g. 1000 cells and 1000 E-genes)}

\item{marginal}{logical to compute the marginal likelihood (TRUE)}

\item{...}{additional parameters for the function getAffinity}
}
\value{
list with cell log odds mixture weights and log likelihood
}
\description{
Calculates responsibilities and mixture weights based on
the ground truth and noisy data.
}
\examples{
sim <- simData(Sgenes = 3, Egenes = 2, Nems = 2, mw = c(0.4,0.6))
data <- sim$data
data[which(sim$data == 1)] <- rnorm(sum(sim$data == 1), 1, 1)
data[which(sim$data == 0)] <- rnorm(sum(sim$data == 0), -1, 1)
fuzzy <- fuzzyindex(sim, data)
}
\author{
Martin Pirkl
}
