% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explained_variance.R
\name{explained_variance}
\alias{explained_variance}
\title{Calculates the proportion of explained variance of multivariate components}
\usage{
explained_variance(data, variates, ncomp)
}
\arguments{
\item{data}{numeric matrix of predictors}

\item{variates}{variates as obtained from a \code{pls} object for instance}

\item{ncomp}{number of components. Should be lower than the number of
columns of \code{variates}}
}
\value{
\code{explained_variance} returns a named numeric vector containing
  the proportion of explained variance for each variate after setting all
  missing values in the data to zero (see details).
}
\description{
\code{explained_variance} calculates the proportion of variance explained by
a set of *orthogonal* variates / components and divides by the total variance
in \code{data} using the definition of 'redundancy'. This applies to any
component-based approaches where components are orthogonal. It is worth
noting that any missing values are set to zero (which is the column mean for
the centered input data) prior to calculation of total variance in the data.
Therefore, this function would underestimate the total variance in presence
of abundant missing values. One can use \code{\link{impute.nipals}} function
to impute the missing values to avoid such behaviour.
}
\details{
Variance explained by component \eqn{t_h} in \eqn{X} for dimension
  \eqn{h}: \deqn{Rd(X, t_h) = \frac{1}{p} \sum_{j = 1}^p \mbox{cor}^2(X^j,
  t_h)} where \eqn{X^j} is the variable centered and scaled, \eqn{p} is the
  total number of variables.
}
\examples{

data(liver.toxicity)
X <- liver.toxicity$gene
Y <- liver.toxicity$clinic

toxicity.spls <- spls(X, Y, ncomp = 2, keepX = c(50, 50), keepY = c(10, 10))

ex = explained_variance(toxicity.spls$X, toxicity.spls$variates$X, ncomp =2)

# ex should be the same as
toxicity.spls$prop_expl_var$X

}
\references{
Tenenhaus, M.,  La Régression PLS théorie et pratique (1998). Technip, Paris, chap2.
}
\seealso{
\code{\link{spls}}, \code{\link{splsda}}, \code{\link{plotIndiv}},
\code{\link{plotVar}}, \code{\link{cim}}, \code{\link{network}}.
}
\author{
Florian Rohart, Kim-Anh Lê Cao, Al J Abadi
}
\keyword{multivariate}
\keyword{regression}
