% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vireo.R
\name{vireoFit}
\alias{vireoFit}
\title{Fit Vireo model with multiple initializations}
\usage{
vireoFit(
  data,
  n.donor,
  n.gt = 3,
  learn.gt = TRUE,
  n.init = 10,
  max.iter = 200,
  random.seed = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{data}{A mitoClone2 data object containing M (ALT) and N (non-ALT) matrices}

\item{n.donor}{Number of donors to identify}

\item{n.gt}{Number of genotype states (default 3)}

\item{learn.gt}{Whether to learn genotype probabilities}

\item{n.init}{Number of random initializations}

\item{max.iter}{Maximum iterations per initialization}

\item{random.seed}{Random seed for reproducibility}

\item{verbose}{Print progress messages}

\item{...}{Additional arguments passed to vireo.filter}
}
\value{
Best fitted Vireo model
}
\description{
Fit Vireo model with multiple initializations
}
\examples{
load(system.file("extdata/LudwigFig7.Rda",package = "mitoClone2"))
test.data <- list(N=as.matrix(t(LudwigFig7@N)),M=as.matrix(t(LudwigFig7@M)))
vireoModel <- vireoFit(test.data, n.donor = 9, filter.variants = FALSE, min_cells_per_sample = 5)
}
