% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/com_dis.R
\name{tina,matrix-method}
\alias{tina,matrix-method}
\title{Function for `tina` dissimilarity calculation. Modified from Schmidt et al.,
2016. Person and Spearman could be used for correlation and weighted and
unweighted Jaccard could be used for similarity calculation.}
\usage{
\S4method{tina}{matrix}(
  x,
  cor_method = "spearman",
  sim_method = "w_ja",
  threads = 80,
  nblocks = 400,
  ...
)
}
\arguments{
\item{x}{A matrix for dissimilarity calculation.}

\item{cor_method}{The method for correlation, "pearson" and "spearman" are
available.}

\item{sim_method}{The method for similarity, "w_ja" and "uw_ja" are
available for weighted and unweighted Jaccard similarity respectively.}

\item{threads}{The number of threads used for parallel running, 80 by
default.}

\item{nblocks}{The number of row and column for splitted sub-matrix, 400 by
default.}

\item{...}{Additional parameters.}
}
\value{
t The output `tina` dissimilarity matrix.
}
\description{
Function for `tina` dissimilarity calculation. Modified from Schmidt et al.,
2016. Person and Spearman could be used for correlation and weighted and
unweighted Jaccard could be used for similarity calculation.
}
\examples{
\dontrun{
asv_norm <- norm_tab(maize_asv2, method = "raref", depth = 1000)
asv_dis <- com_dis(asv_norm, method = "bray")
asv_dis <- com_dis(asv_norm, method = "tina", threads = 8, nblocks = 40)
asv_tina <- tina(asv_norm, cor_method = "spearman", sim_method = "w_ja",
threads = 8, nblocks = 40)
}
}
