% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm_tab.R
\name{norm_tab,matrix,character-method}
\alias{norm_tab,matrix,character-method}
\title{Normalize the quantitative matrix.}
\usage{
\S4method{norm_tab}{matrix,character}(x, method, depth = 1000, replace = TRUE, multi = 1, ...)
}
\arguments{
\item{x}{A quantitative matrix with samples in columns and compositions in
rows.}

\item{method}{The method used for normalization.}

\item{depth}{The depth for rarefying, 1000 by default.}

\item{replace}{Whether to sample with replacement (\code{TRUE} by default)
or without replacement (\code{FALSE}) when using method `raref`.}

\item{multi}{Rarefy the table for multiple times, 1 by default, indicate
the times of rarefaction want to be repeated, only validate for rarefaction.}

\item{...}{Additional parameters.}
}
\value{
The normalized quantitative matrix.

x_norm Normalized matrix of the quantitative table.
}
\description{
Normalize the quantitative matrix.
}
\examples{
data(maize_asv2)
maize_asv_norm <- norm_tab(maize_asv2, method = "total")
maize_asv_norm <- norm_tab(maize_asv2, method = "raref", depth = 1000,
replace = TRUE, multi = 3)
}
