% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generics.R
\name{com_r2}
\alias{com_r2}
\title{Calculate the unexplained variance ratio using formula indicated in:
Anderson, M.J. 2001. A new method for non-parametric multivariate analysis of
variance. Austral Ecology, 26: 32--46.}
\usage{
com_r2(x, group)
}
\arguments{
\item{x}{An object of class `mina` with `dis` and `des` defined.}

\item{group}{The name(s) of column(s) defined as experimental setup group(s).}
}
\value{
Unexplained variance ratio.
}
\description{
Calculate the unexplained variance ratio using formula indicated in:
Anderson, M.J. 2001. A new method for non-parametric multivariate analysis of
variance. Austral Ecology, 26: 32--46.
}
\examples{
data(maize)
maize <- norm_tab(maize, method = "raref", depth = 5000)
maize <- fit_tabs(maize)
maize <- com_dis(maize, method = "bray")
com_r2(maize, group = c("Compartment", "Soil", "Host_genotype"))
}
