% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/com_dis.R
\name{com_dis,mina,ANY-method}
\alias{com_dis,mina,ANY-method}
\alias{com_dis,mina,character-method}
\title{Calculate the community dissimilarity / distance matrix of `norm` with `mina`
class object as input.}
\usage{
\S4method{com_dis}{mina,ANY}(x, method = "bray", threads = 80, nblocks = 400, ...)

\S4method{com_dis}{mina,character}(x, method = "bray", threads = 80, nblocks = 400, ...)
}
\arguments{
\item{x}{An object of the class `mina` with `norm` defined.}

\item{method}{The dissimilarity / distance method used, default `bray`.}

\item{threads}{(optional, only needed when method == "tina") The number of
threads used for parallel running.}

\item{nblocks}{(optional, only needed when method == "tina") The number of
row / column for splitted sub-matrix.}

\item{...}{Additional parameters.}
}
\value{
x The same `mina` object with @dis added.
}
\description{
Calculate the community dissimilarity / distance matrix of `norm` with `mina`
class object as input.
}
\examples{
maize <- new("mina", tab = maize_asv2, des = maize_des2)
maize <- norm_tab(maize, method = "total")
maize <- fit_tabs(maize)
maize <- com_dis(maize, method = "bray")
}
