% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNhoods.R
\name{plotNhoodSizeHist}
\alias{plotNhoodSizeHist}
\title{Plot histogram of neighbourhood sizes}
\usage{
plotNhoodSizeHist(milo, bins = 50)
}
\arguments{
\item{milo}{A \code{\linkS4class{Milo}} object with a non-empty \code{nhoods}
slot.}

\item{bins}{number of bins for \code{geom_histogram}}
}
\value{
A \code{ggplot-class} object
}
\description{
This function plots the histogram of the number of cells belonging to
each neighbourhood
}
\examples{

require(igraph)
require(SingleCellExperiment)
ux.1 <- matrix(rpois(12000, 5), ncol=400)
ux.2 <- matrix(rpois(12000, 4), ncol=400)
ux <- rbind(ux.1, ux.2)
vx <- log2(ux + 1)
pca <- prcomp(t(vx))

sce <- SingleCellExperiment(assays=list(counts=ux, logcounts=vx),
                            reducedDims=SimpleList(PCA=pca$x))
colnames(sce) <- paste0("Cell", seq_len(ncol(sce)))
milo <- Milo(sce)
milo <- buildGraph(milo, k=20, d=10, transposed=TRUE)

milo <- makeNhoods(milo, d=10, prop=0.1)
plotNhoodSizeHist(milo)

}
\author{
Emma Dann
}
