% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphSpatialFDR.R
\name{graphSpatialFDR}
\alias{graphSpatialFDR}
\title{Control the spatial FDR}
\arguments{
\item{x.nhoods}{A list of vertices and the constituent vertices of their
neighbourhood}

\item{graph}{The kNN graph used to define the neighbourhoods}

\item{pvalues}{A vector of p-values calculated from a GLM or other appropriate
statistical test for differential neighbourhood abundance}

\item{k}{A numeric integer that determines the kth nearest neighbour distance to use for
the weighted FDR. Only applicaple when using \code{weighting="k-distance"}.}

\item{weighting}{A string scalar defining which weighting scheme to use.
Choices are: max, k-distance, neighbour-distance or graph-overlap.}

\item{reduced.dimensions}{(optional) A \code{matrix} of cells X reduced dimensions used
to calculate the kNN graph. Only necessary if this function is being used
outside of \code{testNhoods} where the \code{\linkS4class{Milo}}
object is not available}

\item{distances}{(optional) A \code{matrix} of cell-to-cell distances or a list
of distance matrices, 1 per neighbourhood. Only necessary if this function is being
used outside of \code{testNhoods} where the \code{\linkS4class{Milo}}
object is not available.}

\item{indices}{(optional) A list of neighbourhood index vertices in the same order as the input neighbourhoods.
Only used for the k-distance weighting.}
}
\value{
A vector of adjusted p-values
}
\description{
Borrowing heavily from \code{cydar} which corrects for multiple-testing
using a weighting scheme based on the volumetric overlap over hyperspheres.
In the instance of graph neighbourhoods this weighting scheme can use graph
connectivity or incorpate different within-neighbourhood distances for the
weighted FDR calculation.
}
\details{
Each neighbourhood is weighted according to the weighting scheme
defined. k-distance uses the distance to the kth nearest neighbour
of the index vertex, neighbour-distance uses the average within-neighbourhood
Euclidean distance in reduced dimensional space, max uses the largest within-neighbourhood distance
from the index vertex, and graph-overlap uses the total number of cells overlapping between
neighborhoods (distance-independent measure). The frequency-weighted version of the
BH method is then applied to the p-values, as in \code{cydar}.
}
\examples{
NULL
}
\author{
Adapted by Mike Morgan, original function by Aaron Lun
}
