% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmm.R
\name{Satterthwaite_df}
\alias{Satterthwaite_df}
\title{Compute degrees of freedom using Satterthwaite method}
\usage{
Satterthwaite_df(
  coeff.mat,
  mint,
  cint,
  SE,
  curr_sigma,
  curr_beta,
  V_partial,
  V_a,
  G_inv,
  random.levels
)
}
\arguments{
\item{coeff.mat}{A \code{matrix} class object containing the coefficient matrix from the mixed model equations}

\item{mint}{A numeric scalar of the number of fixed effect variables in the model}

\item{cint}{A numeric scalar of the number of random effect variables in the model}

\item{SE}{A \code{1 x mint} \code{matrix}, i.e. column vector, containing the standard errors of the fixed effect
parameter estimates}

\item{curr_sigma}{A \code{1 x cint matrix}, i.e. column vector, of the variance component parameter estimates}

\item{curr_beta}{A \code{1 x mint matrix}, i.e. column vector, of the fixed effect parameter estimates}

\item{V_partial}{A \code{list} of the partial derivatives for each fixed and random effect variable in the model}

\item{V_a}{A \code{c+m x c+m} variance-covariance matrix of the fixed and random effect variable parameter estimates}

\item{G_inv}{A \code{nxc X nxc} inverse matrix containing the variance component estimates}

\item{random.levels}{A \code{list} containing the mapping between the random effect variables and each respective set
of levels for said variable.}
}
\value{
\code{matrix} containing the inferred number of degrees of freedom for the specific model.
}
\description{
This function is not intended to be called by the user, and is included for reference
}
\details{
The Satterthwaite degrees of freedom are computed, which estimates the numbers of degrees of freedom in the
NB-GLMM based on ratio of the squared standard errors and the product of the Jacobians of the variance-covariance matrix
from the fixed effect variable parameter estimation with full variance-covariance matrix. For more details see
Satterthwaite FE, Biometrics Bulletin (1946) Vol 2 No 6, pp110-114.
}
\examples{
NULL

}
\author{
Mike Morgan & Alice Kluzer
}
