% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformationFunctions.R
\name{getHlaKirInteractions}
\alias{getHlaKirInteractions}
\title{Get HLA - KIR interactions}
\usage{
getHlaKirInteractions(
  hla_calls,
  kir_calls,
  interactions_dict = system.file("extdata", "Match_counts_hla_kir_interactions.txt",
    package = "midasHLA")
)
}
\arguments{
\item{hla_calls}{HLA calls data frame, as returned by
\code{\link{readHlaCalls}} function.}

\item{kir_calls}{KIR calls data frame, as returned by
\code{\link{readKirCalls}} function.}

\item{interactions_dict}{Path to HLA - KIR interactions dictionary.}
}
\value{
Data frame with variable number of columns. First column named 
  \code{"ID"} corresponds to \code{"ID"} column in \code{counts}, further
  columns hold indicators for HLA - KIR interactions. \code{1} and \code{0} 
  code presence and absence of a variable respectively.
}
\description{
\code{getHlaKirInteractions} calculate presence-absence matrix of HLA - KIR
interactions.
}
\details{
\code{hla_calls} are first reduced to all possible resolutions and converted
to additional variables, such as G groups, using dictionaries shipped with
the package.

\code{interactions_dict} file should be a tsv format with header and two
columns. First column should be named \code{"Name"} and hold interactions
names, second should be named \code{"Expression"} and hold expression used to
identify interaction (eg. \code{"C2 & KIR2DL1"} will match all samples
with \code{C2} and \code{KIR2DL1}). The package is shipped with an interactions
file based on \href{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC6558367/}{Pende et al., 2019.}
}
\examples{
getHlaKirInteractions(
  hla_calls = MiDAS_tut_HLA, 
  kir_calls = MiDAS_tut_KIR, 
  interactions_dict = system.file(
    "extdata", "Match_counts_hla_kir_interactions.txt", 
    package = "midasHLA")
)

}
