% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformationFunctions.R
\name{filterExperimentByFrequency}
\alias{filterExperimentByFrequency}
\alias{filterExperimentByFrequency.matrix}
\alias{filterExperimentByFrequency.SummarizedExperiment}
\title{Filter experiment by frequency}
\usage{
filterExperimentByFrequency(
  experiment,
  carrier_frequency = FALSE,
  lower_frequency_cutoff = NULL,
  upper_frequency_cutoff = NULL
)

\method{filterExperimentByFrequency}{matrix}(
  experiment,
  carrier_frequency = FALSE,
  lower_frequency_cutoff = NULL,
  upper_frequency_cutoff = NULL
)

\method{filterExperimentByFrequency}{SummarizedExperiment}(
  experiment,
  carrier_frequency = FALSE,
  lower_frequency_cutoff = NULL,
  upper_frequency_cutoff = NULL
)
}
\arguments{
\item{experiment}{Matrix or SummarizedExperiment object.}

\item{carrier_frequency}{Logical flag indicating if carrier frequency should
be returned.}

\item{lower_frequency_cutoff}{Positive number or \code{NULL}. Numbers greater
than 1 are interpreted as number of feature occurrences, numbers between 0
and 1 as fractions.}

\item{upper_frequency_cutoff}{Positive number or \code{NULL}. Numbers greater
than 1 are interpreted as number of feature occurrences, numbers between 0
and 1 as fractions.}
}
\value{
Filtered experiment matrix.
}
\description{
Helper function for experiments filtering
}
