% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{convertAlleleToVariable}
\alias{convertAlleleToVariable}
\title{Convert allele numbers to additional variables}
\usage{
convertAlleleToVariable(allele, dictionary)
}
\arguments{
\item{allele}{Character vector with HLA allele numbers.}

\item{dictionary}{Path to file containing HLA allele dictionary or a
data frame.}
}
\value{
Vector containing HLA allele numbers converted to additional
  variables according to \code{dictionary}.
}
\description{
\code{convertAlleleToVariable} converts input HLA allele numbers to additional
variables based on the supplied dictionary.
}
\details{
\code{dictionary} file should be a tsv format with header and two columns.
First column should hold allele numbers, second additional variables (eg.
expression level).

Type of the returned vector depends on the type of the additional variable.
}
\examples{
dictionary <- system.file("extdata", "Match_allele_HLA_supertype.txt", package = "midasHLA")
convertAlleleToVariable(c("A*01:01", "A*02:01"), dictionary = dictionary)

}
