% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{analyzeConditionalAssociations}
\alias{analyzeConditionalAssociations}
\title{Stepwise conditional association analysis}
\usage{
analyzeConditionalAssociations(
  object,
  variables,
  placeholder = "term",
  correction = "bonferroni",
  n_correction = NULL,
  th,
  th_adj = TRUE,
  keep = FALSE,
  rss_th = 1e-07,
  exponentiate = FALSE
)
}
\arguments{
\item{object}{An existing fit from a model function such as lm, glm and many
others.}

\item{variables}{Character vector specifying variables to use in association
tests.}

\item{placeholder}{String specifying term to substitute with value from
\code{x}. Ignored if set to \code{NULL}.}

\item{correction}{String specifying multiple testing correction method. See
details for further information.}

\item{n_correction}{Integer specifying number of comparisons to consider
during multiple testing correction calculations. For Bonferroni correction
it is possible to specify a number lower than the number of comparisons
being made. This is useful in cases when knowledge about the biology or
redundance of alleles reduces the need for correction. For other methods it
must be at least equal to the number of comparisons being made; only set
this (to non-default) when you know what you are doing!}

\item{th}{Number specifying threshold for a variable to be considered
significant.}

\item{th_adj}{Logical flag indicating if adjusted p-value should be used as
threshold criteria, otherwise unadjusted p-value is used.}

\item{keep}{Logical flag indicating if the output should be a list of results
resulting from each selection step. Default is to return only the final
result.}

\item{rss_th}{Number specifying residual sum of squares threshold at which
function should stop adding additional variables. As the residual sum of
squares approaches \code{0} the perfect fit is obtained making further
attempts at variable selection nonsense. This behavior can be controlled
using \code{rss_th}.}

\item{exponentiate}{Logical flag indicating whether or not to exponentiate
the coefficient estimates. Internally this is passed to
\code{\link[broom]{tidy}}. This is typical for logistic and multinomial
regressions, but a bad idea if there is no log or logit link. Defaults to
FALSE.}
}
\value{
Tibble with stepwise conditional testing results or a list of tibbles,
 see \code{keep} argument. The first column \code{"term"} hold the names of 
 \code{variables}. Further columns depends on the used model and are 
 determined by associated \code{tidy} function. Generally they will include 
 \code{"estimate"}, \code{"std.error"}, \code{"statistic"}, \code{"p.value"}, 
 \code{"conf.low"}, \code{"conf.high"}, \code{"p.adjusted"}.
}
\description{
\code{analyzeConditionalAssociations} perform stepwise conditional testing
adding the previous top-associated variable as covariate, until there are no
more significant variables based on a self-defined threshold.
}
\examples{
midas <- prepareMiDAS(hla_calls = MiDAS_tut_HLA,
                      colData = MiDAS_tut_pheno,
                      experiment = "hla_alleles")

# analyzeConditionalAssociations expects model data to be a data.frame
midas_data <- as.data.frame(midas)

# define base model
object <- lm(disease ~ term, data = midas_data)
analyzeConditionalAssociations(object,
                            variables = c("B*14:02", "DRB1*11:01"),
                            th = 0.05)

}
