% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_composition.R
\name{plot_composition}
\alias{plot_composition}
\title{Taxonomic Composition Plot}
\usage{
plot_composition(
  x,
  sample.sort = NULL,
  otu.sort = NULL,
  x.label = "sample",
  plot.type = "barplot",
  verbose = FALSE,
  average_by = NULL,
  group_by = NULL,
  ...
)
}
\arguments{
\item{x}{\code{\link{phyloseq-class}} object}

\item{sample.sort}{Order samples. Various criteria are available:
\itemize{
\item NULL or 'none': No sorting
\item A single character string: indicate the metadata field to be used
 for ordering. Or: if this string is found from the tax_table, then sort
 by the
 corresponding taxonomic group.
\item A character vector: sample IDs indicating the sample ordering.
\item 'neatmap' Order samples based on the neatmap approach.
See \code{\link{neatsort}}. By default, 'NMDS' method with 'bray'
distance is used. For other options, arrange the samples manually
with the function.
}}

\item{otu.sort}{Order taxa. Same options as for the sample.sort argument
but instead of metadata, taxonomic table is used.
Also possible to sort by 'abundance'.}

\item{x.label}{Specify how to label the x axis.
This should be one of the variables in sample_variables(x).}

\item{plot.type}{Plot type: 'barplot' or 'heatmap'}

\item{verbose}{verbose
 (but not in sample/taxon ordering).
The options are 'Z-OTU', 'Z-Sample', 'log10' and 'compositional'.
See the \code{\link{transform}} function.}

\item{average_by}{Average the samples by the average_by variable}

\item{group_by}{Group by this variable (in plot.type "barplot")}

\item{...}{Arguments to be passed (for \code{\link{neatsort}} function)}
}
\value{
A \code{\link{ggplot}} plot object.
}
\description{
Plot taxon abundance for samples.
}
\examples{
library(dplyr)
data(atlas1006)
pseq <- atlas1006 \%>\%
   subset_samples(DNA_extraction_method == "r") \%>\%
   aggregate_taxa(level = "Phylum") \%>\%
   transform(transform = "compositional")
p <- plot_composition(pseq, sample.sort = "Firmicutes",
         otu.sort = "abundance", verbose = TRUE) +
     scale_fill_manual(values = default_colors("Phylum")[taxa(pseq)]) 
}
\keyword{utilities}
