% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heat.R
\name{heat}
\alias{heat}
\title{Association Heatmap}
\usage{
heat(
  df,
  Xvar = names(df)[[1]],
  Yvar = names(df)[[2]],
  fill = names(df)[[3]],
  star = NULL,
  p.adj.threshold = 1,
  association.threshold = 0,
  step = 0.2,
  colours = c("darkblue", "blue", "white", "red", "darkred"),
  limits = NULL,
  legend.text = "",
  order.rows = TRUE,
  order.cols = TRUE,
  filter.significant = TRUE,
  star.size = NULL,
  plot.values = FALSE
)
}
\arguments{
\item{df}{Data frame. Each row corresponds to a pair of associated 
variables. The columns give variable names, association scores and 
significance estimates.}

\item{Xvar}{X axis variable column name. For instance 'X'.}

\item{Yvar}{Y axis variable column name. For instance 'Y'.}

\item{fill}{Column to be used for heatmap coloring. 
For instance 'association'.}

\item{star}{Column to be used for cell highlighting. For instance 'p.adj'.}

\item{p.adj.threshold}{Significance threshold for the stars.}

\item{association.threshold}{Include only elements that have absolute 
association higher than this value}

\item{step}{color interval}

\item{colours}{heatmap colours}

\item{limits}{colour scale limits}

\item{legend.text}{legend text}

\item{order.rows}{Order rows to enhance visualization
interpretability. If this is logical, then hclust is applied. If this
is a vector then the rows are ordered using this index.}

\item{order.cols}{Order columns to enhance visualization
interpretability. If this is logical, then hclust is applied. If this
is a vector then the rows are ordered using this index.}

\item{filter.significant}{Keep only the elements with at least one 
significant entry}

\item{star.size}{NULL Determine size of the highlight symbols}

\item{plot.values}{Show values as text}
}
\value{
ggplot2 object
}
\description{
Visualizes n x m association table as heatmap.
}
\examples{
data(peerj32)
d1 <- peerj32$lipids[, 1:10]
d2 <- peerj32$microbes[, 1:10]
cc <- associate(d1, d2, method='pearson') 
p <- heat(cc, 'X1', 'X2', 'Correlation', star='p.adj')
}
\references{
See citation('microbiome')
}
\author{
Contact: Leo Lahti \email{microbiome-admin@googlegroups.com}
}
\keyword{utilities}
