% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_besthit.R
\name{add_besthit}
\alias{add_besthit}
\title{Adds \code{best_hist} to a \code{\link{phyloseq-class}} Object}
\usage{
add_besthit(x, sep = ":")
}
\arguments{
\item{x}{\code{\link{phyloseq-class}} object}

\item{sep}{separator e.g. ASV161:Roseburia}
}
\value{
\code{\link{phyloseq-class}} object \code{\link{phyloseq-class}}
}
\description{
Add the lowest classification for an OTU or ASV.
}
\details{
Most commonly it is observed that taxa names are either OTU ids or 
         ASV ids. In such cases it is useful to know the taxonomic identity.
         For this purpose, \code{best_hist} identifies the best available 
         taxonomic identity and adds it to the OTU ids or ASV ids. If genus 
         and species columns are present in input the function internally 
         combines the names.
}
\examples{
\dontrun{
# Example data
library(microbiome)
data(dietswap)
p0.f <- add_besthit(atlas1006, sep=":")
}
}
\author{
Contact: Sudarshan A. Shetty \email{sudarshanshetty9@gmail.com}
}
\keyword{utilities}
