% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_functions.R
\name{plotlySampleBarplot}
\alias{plotlySampleBarplot}
\title{Function plotting a barplot showing number of OTUs per samples}
\usage{
plotlySampleBarplot(
  MRobj,
  col_by = NULL,
  xaxisTitle = "",
  yaxisTitle = "",
  pwidth = 600,
  pheight = 450,
  sortbyfreq = FALSE,
  pheno_sort = NULL,
  x_levels = NULL
)
}
\arguments{
\item{MRobj}{containing data to plot}

\item{col_by}{phenotype to color bars by; default is NULL}

\item{xaxisTitle}{name of xaxis; default is ""}

\item{yaxisTitle}{name of yaxis; default is ""}

\item{pwidth}{overall plot width; default is 600}

\item{pheight}{overall plot height; default is 450}

\item{sortbyfreq}{boolean determining if bars should be sorted by frequency; 
default is FALSE}

\item{pheno_sort}{order of pheno levels to sort by; 
ignored if sortbyfreq is TRUE}

\item{x_levels}{character vector holding x values in order to be shown}
}
\value{
plotly plot object
}
\description{
Function plotting a barplot showing number of OTUs per samples
}
\examples{
data("mouseData", package = "metagenomeSeq")
plotlySampleBarplot(mouseData)

}
