% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{buildPlottingDF}
\alias{buildPlottingDF}
\title{Sets up a dataframe used by several plotting functions by joining
the required data with relevant phenotype data}
\usage{
buildPlottingDF(
  df,
  phenoTable,
  x_var = NULL,
  facet1 = NULL,
  facet2 = NULL,
  col_by = NULL,
  col_name = col_by,
  id_var = NULL
)
}
\arguments{
\item{df}{dataframe storing plotting data values}

\item{phenoTable}{pData of the MRexperiment; all following parameters must be 
a column of the phenoTable}

\item{x_var}{main plotting variable}

\item{facet1}{column-based faceting (can be NULL)}

\item{facet2}{row-based faceting (can be NULL)}

\item{col_by}{coloring factor (can be NULL)}

\item{col_name}{character to be used as name for col_by}

\item{id_var}{variable used to connect samples longitudinally (can be NULL)}
}
\value{
dataframe obtained by joining df and relevant columns of phenoTable
}
\description{
Sets up a dataframe used by several plotting functions by joining
the required data with relevant phenotype data
}
