% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/treeData.R
\name{rowTreeData}
\alias{rowTreeData}
\alias{colTreeData}
\alias{rowTreeData<-}
\alias{colTreeData<-}
\alias{combineTreeData}
\alias{treeData}
\alias{colTreeData,TreeSummarizedExperiment-method}
\alias{rowTreeData,TreeSummarizedExperiment-method}
\alias{colTreeData<-,TreeSummarizedExperiment-method}
\alias{rowTreeData<-,TreeSummarizedExperiment-method}
\alias{combineTreeData,phylo-method}
\alias{combineTreeData,treedata-method}
\title{Adding information to tree data in \code{TreeSummarizedExperiment}}
\usage{
rowTreeData(x, ...)

colTreeData(x, ...)

rowTreeData(x, tree.name = tree_name, tree_name = "phylo") <- value

colTreeData(x, tree.name = tree_name, tree_name = "phylo") <- value

combineTreeData(x, other.fields = other_fields, other_fields = list())

combineTreeData(x, other.fields = other_fields, other_fields = list())

\S4method{colTreeData}{TreeSummarizedExperiment}(x, tree.name = tree_name, tree_name = "phylo")

\S4method{rowTreeData}{TreeSummarizedExperiment}(x, tree.name = tree_name, tree_name = "phylo")

\S4method{colTreeData}{TreeSummarizedExperiment}(x, tree.name = tree_name, tree_name = "phylo") <- value

\S4method{rowTreeData}{TreeSummarizedExperiment}(x, tree.name = tree_name, tree_name = "phylo") <- value

\S4method{combineTreeData}{phylo}(x, other.fields = other_fields, other_fields = list())

\S4method{combineTreeData}{treedata}(x, other.fields = other_fields, other_fields = list())
}
\arguments{
\item{x}{a
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}
object.}

\item{...}{additional arguments, currently not used.}

\item{tree.name}{\code{Character scalar}. Specifies a rowTree/colTree from
\code{x}. (Default: \code{"phylo"})}

\item{tree_name}{Deprecated. Use \code{tree.name} instead.}

\item{other.fields, value}{a \code{data.frame} or coercible to one, with at
least one type of id information. See details.(Default: \code{list()})}

\item{other_fields}{Deprecated. Use \code{other.fields} instead.}
}
\value{
a \code{data.frame} for the accessor and the modified
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}
object
}
\description{
To facilitate the dressing of the tree data stored in a
\code{TreeSummarizedExperiment} object, \code{rowTreeData} and
\code{colTreeData} can be used.
}
\details{
To match information to nodes, the id information in \code{other.fields} are
used. These can either be a column, named \sQuote{node} or \sQuote{label}
(\sQuote{node} taking precedent), or rownames. If all rownames can be coerced
to \code{integer}, they are considered as \sQuote{node} values, otherwise as
\sQuote{label} values. The id information must be unique and match available
values of \code{rowTreeData(c)}

The result of the accessors, \code{rowTreeData} and \code{colTreeData},
contain at least a \sQuote{node} and \sQuote{label} column.
}
\examples{
data(GlobalPatterns)
td <- rowTreeData(GlobalPatterns)
td
td$test <- rnorm(nrow(td))
rowTreeData(GlobalPatterns) <- td
rowTreeData(GlobalPatterns)
combineTreeData(rowTree(GlobalPatterns), td)
}
