% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRLAB.R
\name{convert}
\alias{convert}
\title{Convert miRNA symbols from a miRBase version to another}
\usage{
convert(miRNAListFile, sourceV, targetV)
}
\arguments{
\item{miRNAListFile}{the input file containing a list of miRNA symbols in csv format}

\item{sourceV}{the miRBase version of the input miRNAs, e.g. 16. If users do not know the version, use 0.}

\item{targetV}{the miRBase version that we want to convert into, e.g. 21.}
}
\value{
A csv file in the working directory containing the converted miRNA symbols.
}
\description{
This function convert the miRNAs in the input file from the "source" miRBase version to the "Target" version. 
If users do not know the miRBase version of the input file, please set the source version to 0. The function will match the 
miRNAs in the input file to all miRBase versions to find the most likely miRBase version. Currently, we have versions 16-21.
}
\examples{
miRs=system.file("extdata", "ToymiRs.csv", package="miRLAB")
convert(miRs, 17, 21) 
}
