% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRLAB.R
\name{Elastic}
\alias{Elastic}
\title{miRNA target prediction with the Elastic-net regression coefficient method}
\usage{
Elastic(datacsv, cause, effect, targetbinding = NA)
}
\arguments{
\item{datacsv}{the input dataset in csv format}

\item{cause}{the column range that specifies the causes (miRNAs), e.g. 1:35}

\item{effect}{the column range that specifies the effects (mRNAs), e.g. 36:2000}

\item{targetbinding}{the putative target, e.g. "TargetScan.csv". If targetbinding is not specified, only expression data is used.
If targetbinding is specified, the prediction results using expression data with be intersected with the interactions in the target binding file.}
}
\value{
A  matrix that includes the Elastic-net regression coefficients. Columns are miRNAs, rows are mRNAs.
}
\description{
Calculate the Elastic-net regression coefficient of each pair of miRNA-mRNA,and return a matrix of correlation coefficients with columns are miRNAs and rows are mRNAs.
}
\examples{
dataset=system.file("extdata", "ToyEMT.csv", package="miRLAB")
results=Elastic(dataset, 1:3, 4:18) 
}
\references{
1. Le, T.D., Zhang, J., Liu, L., and Li, J. (2015) Ensemble Methods for miRNA Target Prediction from Expression Data, under review.

2. Zou, H., & Hastie, T. (2005). Regularization and variable selection via the elastic net. J. R. Stat. Soc. Series B Stat. Methodol., 67, 301-320.
}
